/*********************************************************************************
*Copyright (C), 2017, Shanghai Eastsoft Microelectronics Co., Ltd.
*ļ:	flash.c
*  :	LinXY
*  :	V2.00
*  :	2017/4/1
*  :	flash
*  ע:   
ѧϰʾʹãûֱôķջеκηΡ
**********************************************************************************/

/* includes --------------------------------------------------------------------------------------*/
#include "flash.h"


/* private typedef -------------------------------------------------------------------------------*/
/* flash*/
typedef struct {
	uchar A;
	uchar B;
}flash_option_state_t;


/* flashַ*/
typedef struct {
	uint A;
	uint B;
}flash_addr_t;

/* private define --------------------------------------------------------------------------------*/
/* flash option enable/disable */
#define FLASH_OPTION_ENABLE_A		0x5A
#define FLASH_OPTION_ENABLE_B		0x5B

#define FLASH_OPTION_DISABLE_A		0x00
#define FLASH_OPTION_DISABLE_B		0x00

/* private macro ---------------------------------------------------------------------------------*/

/* private variables -----------------------------------------------------------------------------*/
/* Flashر*/
flash_option_state_t   s_tFlashOptionState;		//!< optione״̬
flash_addr_t           s_tFlashAddr[34];		//!< ַ

/* private function prototypes -------------------------------------------------------------------*/



/***************************************************************************************************
                                              
***************************************************************************************************/

bool flash_page_check(uint page)
{
	/*
	if (FLASH_PAGE_30 != page) {
		return false;
	}
	*/
	return true;
}

/**
  * @brief   flashԶдԺڸտʱڲԣҪʹ
  * @param   [in]page:ҪԵҳַ
  * @retval  true:ɹ/false:ʧ
  * @author  linxy
  * @date    2016/11/29
  * @note    
  */
bool flash_fast_auto_test(uint page, uchar page_offset)
{
	uchar  chFlashTest[8];
	uchar  cnt;
	uchar  i;

	flash_option_enable();
	flash_erase(page);
	flash_option_disable();

	/*!< ٳʼ */
	flash_fast_auto_init(page, page_offset, sizeof(chFlashTest));

	/*!< ѭд150 */
	for (cnt = 1; cnt <= 150; cnt++) {
		/*!< ʼ */
		for (i = 0; i < ARRAY_SIZE(chFlashTest); i++) {
			chFlashTest[i] = (uchar)(cnt * i+1);
		}

		/*!< д */
		flash_fast_auto_write(page, page_offset, (uchar *)chFlashTest, sizeof(chFlashTest));

		/*!<  */
		for (i = 0; i < ARRAY_SIZE(chFlashTest); i++) {
			chFlashTest[i] = 0;
		}

		/*!< ȡ */
		flash_fast_auto_read(page, page_offset, (uchar *)chFlashTest, sizeof(chFlashTest));

		/*!< Ƿдͬ */
		for (i = 0; i < ARRAY_SIZE(chFlashTest); i++) {
			if (chFlashTest[i] != (uchar)(cnt * i+1)) {
				flash_erase(page);
				return false;
			}
		}
	}

	/*!< ҳ */
	flash_erase(page);

	return true;
}

/**
  * @brief   flashԶȡ
  * @param   [in]page:flashҳַ
  * @param   [out]pdat:ָ
  * @param   [in]len:ֽڳ
  * @retval  true:ɹ/false:ʧ
  * @author  linxy
  * @date    2016/11/29
  * @note    дҪflash_fast_auto_write.
  */
bool flash_fast_auto_read(uint page, uchar page_offset, uchar *pdat, uint len)
{
	uint        addr;
	uint        item;
	hword_to_byte_t temp;
	flash_addr_t    *pFlashAddr;

	/*!< ҳַ */
	if (false == flash_page_check(page)) {
		return false;
	}

	/*!< 2ֽڶַ */
	if (!len) {
		return false;
	}
	item = len + 4 + 1;
	item = item & 0xFFFE;
	item = item >> 1;

	/*!< ҳλ */
	pFlashAddr = &s_tFlashAddr[page_offset];
	if (pFlashAddr->A != pFlashAddr->B) {
		return false;
	}
	addr = pFlashAddr->A;

	/*!< ַ */
	if (!addr) {
		return false;
	}

	/*!< ַƫ */
	addr = addr - item;
	addr = addr + 1;

	/*!< ѭ */
	while (1) {
		flash_read_hword(page, addr, &temp.hWord);
		addr++;
		if (len) {
			len--;
			*pdat = temp.chByte[0];
			pdat++;
		}
		if (len) {
			len--;
			*pdat = temp.chByte[1];
			pdat++;
		}
		if (!len) {
			break;
		}
	}

	return true;
}

/**
  * @brief   flashԶд룬ڲʹƽд
  * @details ָһҳԶƽдݣһҳд󣬽ҳ.
  * @param   [in]page:ҳַ
  * @param   [in]pdat:ָ
  * @param   [in]len: ݳ
  * @retval  true:ɹ/false:ʧ
  * @author  linxy
  * @date    2016/11/29
  * @note    ȡҪflash_fast_auto_read. 
  */
bool flash_fast_auto_write(uint page, uchar page_offset, uchar *pdat, uint len)
{
	bool            bret;
	uint        addr;
	uint        item;
	hword_to_byte_t temp;
	flash_addr_t    *pFlashAddr;

	/*!< ҳַ */
	if (false == flash_page_check(page)) {
		return false;
	}

	/*!< 2ֽڶַ */
	if (!len) {
		return false;
	}
	item = len + 4 + 1;
	item = item & 0xFFFE;
	item = item >> 1;

	/*!< ҳλ */
	pFlashAddr = &s_tFlashAddr[page_offset];
	if (pFlashAddr->A != pFlashAddr->B) {
		return false;
	}
	addr = pFlashAddr->A;

	/*!< ռǷ㹻 */
	if (addr >= (512 - item)) {
		addr  = 0;
		flash_option_enable();
		bret = flash_erase(page);
		flash_option_disable();
		if (!bret) {
			return false;
		}
		pFlashAddr->A = 0;
		pFlashAddr->B = 0;
	}

	/*!< дʶͷ */
	flash_option_enable();
	temp.hWord = FLASH_HEAD_MARK;
	flash_write_hword(page, addr, temp.hWord);
	addr++;

	/*!< д */
	while (1) {
		/*!<  */
		temp.hWord = 0;

		/*!< ȡ1ֽ */
		if (len) {
			len--;
			temp.chByte[0] = *pdat;
			pdat++;
		}

		/*!< ȡ1ֽ */
		if (len) {
			len--;
			temp.chByte[1] = *pdat;
			pdat++;
		}

		/*!< д */
		flash_write_hword(page, addr, temp.hWord);
		addr++;
		if (!len) {
			break;
		}
	}

	flash_option_disable();

	/*!< µַ */
	pFlashAddr->A += item;
	pFlashAddr->B += item;

	return true;
}

/**
  * @brief   flashԶʼ.
  * @param   [in]page:flashҳַ.
  * @param   [in]len: ݳ
  * @retval  true:ɹ/false:ʧ
  * @author  linxy
  * @date    2016/11/29
  * @note    
  */
bool flash_fast_auto_init(uint page, uchar page_offset, uint len)
{
	uint        addr;
	uint        item;
	hword_to_byte_t temp;

	/*!< ҳַ */
	if (false == flash_page_check(page)) {
		return false;
	}

	item = len + 4 + 1;
	item = item & 0xFFFE;
	item = item >> 1;

	/*!< ҳλ */
	for (addr = 0; addr < 512; addr += item) {
		flash_read_hword(page, addr, &temp.hWord);
		if (FLASH_HEAD_MARK != temp.hWord) {
			s_tFlashAddr[page_offset].A = s_tFlashAddr[page_offset].B = addr;
			return true;
		}
	}

	return false;
}

/**
  * @brief   flashԶдԺڸտʱڲԣҪʹ
  * @param   [in]page:ҪԵҳַ
  * @retval  true:ɹ/false:ʧ
  * @author  linxy
  * @date    2016/11/29
  * @note    
  */
bool flash_auto_test(uint page)
{
	uchar  chFlashTest[8];
	uchar  cnt;
	uchar  i;

	flash_option_enable();
	flash_erase(page);
	flash_option_disable();
	/*!< ѭд150 */
	for (cnt = 1; cnt <= 150; cnt++) {
		/*!< ʼд */
		for (i = 0; i < ARRAY_SIZE(chFlashTest); i++) {
			chFlashTest[i] = (uchar)(cnt * i+1);
		}
		
		/*!< дflash */
		flash_auto_write(page, (uchar *)chFlashTest, sizeof(chFlashTest));
		
		/*!<  */
		for (i = 0; i < ARRAY_SIZE(chFlashTest); i++) {
			chFlashTest[i] = 0;
		}

		/*!< flashжȡ */
		flash_auto_read(page, (uchar *)chFlashTest, sizeof(chFlashTest));

		/*!< ÿһݺдǷͬ */
		for (i = 0; i < ARRAY_SIZE(chFlashTest); i++) {
			if (chFlashTest[i] != (uchar)(cnt * i+1)) {
				flash_erase(page);
				return false;
			}
		}
	}

	/*!< ²ҳ */
	flash_erase(page);

	return true;
}

/**
  * @brief   flashԶȡ
  * @param   [in]page:flashҳַ
  * @param   [out]pdat:ָ
  * @param   [in]len:ֽڳ
  * @retval  true:ɹ/false:ʧ
  * @author  linxy
  * @date    2016/11/29
  * @note    дҪflash_auto_write
  */
bool flash_auto_read(uint page, uchar *pdat, uint len)
{
	uint        addr;
	uint        item;
	hword_to_byte_t temp;

	/*!< ҳַǷϷ*/
	if (false == flash_page_check(page)) {
		return false;
	}

	/*!< 2ֽڶַ */
	if (!len) {
		return false;
	}
	item = len + 4 + 1;
	item = item & 0xFFFE;
	item = item >> 1;

	/*!< ҳλ */
	for (addr = 0; addr < 512; addr += item) {
		flash_read_hword(page, addr, &temp.hWord);
		if (FLASH_HEAD_MARK != temp.hWord) {
			break;
		}
	}

	/*!< ַ */
	if (!addr) {
		return false;
	}

	/*!< ַƫ */
	addr = addr - item;
	addr = addr + 1;

	/*!< ѭ */
	while (1) {
		flash_read_hword(page, addr, &temp.hWord);
		addr++;
		if (len) {
			len--;
			*pdat = temp.chByte[0];
			pdat++;
		}
		if (len) {
			len--;
			*pdat = temp.chByte[1];
			pdat++;
		}
		if (!len) {
			break;
		}
	}

	return true;
}

/**
  * @brief   flashԶд룬ڲʹƽд
  * @details ָһҳԶƽдݣһҳд󣬽ҳ
  * @param   [in]page:ҳַ
  * @param   [in]pdat:ָ
  * @param   [in]len: ݳ
  * @retval  true:ɹ/false:ʧ
  * @author  linxy
  * @date    2016/11/29
  * @note    ȡҪflash_auto_read
  */
bool flash_auto_write(uint page, uchar *pdat, uint len)
{
	bool            bret;
	uint        addr;
	uint        item;
	hword_to_byte_t temp;

	/*!< ҳַǷϷ*/
	if (false == flash_page_check(page)) {
		return false;
	}

	/*!< 2ֽڶַ */
	if (!len) {
		return false;
	}
	item = len + 4 + 1;
	item = item & 0xFFFE;
	item = item >> 1;

	/*!< ҳλ */
	for (addr = 0; addr < 512; addr += item) {
		flash_read_hword(page, addr, &temp.hWord);
		if (FLASH_HEAD_MARK != temp.hWord) {
			break;
		}
	}

	/*!< ռǷ㹻 */
	if (addr >= (512 - item)) {
		addr  = 0;
		flash_option_enable();
		bret = flash_erase(page);
		flash_option_disable();
		if (!bret) {
			return false;
		}
	}

	/*!< дʶͷ */
	flash_option_enable();
	temp.hWord = FLASH_HEAD_MARK;
	flash_write_hword(page, addr, temp.hWord);
	addr++;

	/*!< д */
	while (1) {
		/*!<  */
		temp.hWord = 0;

		/*!< ȡ1ֽ */
		if (len) {
			len--;
			temp.chByte[0] = *pdat;
			pdat++;
		}

		/*!< ȡ1ֽ */
		if (len) {
			len--;
			temp.chByte[1] = *pdat;
			pdat++;
		}

		flash_write_hword(page, addr, temp.hWord);
		
		addr++;
		if (!len) {
			break;
		}
	}

	flash_option_disable();

	return true;
}

/**
  * @brief   flashд
  * @param   [in]page:ҳַ
  * @retval  true:/false:쳣
  * @author  linxy
  * @date    2016/11/29
  * @note    ʼʹõʱʹô˺flashڲԺʾʹ.
  */
bool flash_hword_test(uint page)
{
	uint temp = 0;

	flash_option_enable();				//!< ʹ
	flash_erase(page);					//!< ҳ
	flash_write_hword(page, 0, 0x5A5A);	//!< д
	flash_read_hword(page, 0, &temp);	//!< 
	flash_erase(page);                  //!< ҳ
	flash_option_disable();				//!< ֹ
	
	if (temp != 0x5A5A) {
		return true;
	}

	return false;
}

bool flash_array_test(uint page, uchar *parray, uchar len)
{
	uint temp;
	uchar  i;
	uchar  *p;
	
	//!< ָҳpage
	flash_option_enable();
	flash_erase(page);
	flash_option_disable();	
	
	//!< дpageҳʼַ0
	flash_option_enable();
	for (p = parray, i = 0; i < len; i++) {
		temp = *p;
		flash_write_hword(page, i, temp);
		p++;
	}
	flash_option_disable();
	
	//!< Ѹд¶
	for (p = parray, i = 0; i < len; i++) {
		flash_read_hword(page, i, &temp);
		*p = (uchar)temp;
		p++;
	}
}

bool flash_write_byte(uint page, uint offsetaddr, uchar byte_h, uchar byte_l)
{
	uchar bgie;
	hword_to_byte_t tvar;

	/*!< Ƿ */
	if ((s_tFlashOptionState.A != FLASH_OPTION_ENABLE_A) ||
	    (s_tFlashOptionState.B != FLASH_OPTION_ENABLE_B)) {
		return false;
	}

	/*!< ҳַǷϷ*/
	if (false == flash_page_check(page)) {
		return false;
	}

	bgie = 0;
	if (GIE) {
		GIE  = 0;
		bgie = 1;
	}

	WDTUL  = 0x5A;
	SWDTEN = 0;

	tvar.hWord = page + offsetaddr;
	FRAH  = tvar.chByte[1];
	FRAHN = ~tvar.chByte[1];
	FRAL  = tvar.chByte[0];
	FRALN = ~tvar.chByte[0];

	ROMDH  = byte_h;
	ROMDL  = byte_l;
	ROMDHN = ~byte_h;
	ROMDLN = ~byte_l;

	IAPCLR  = 1;
	IAPUL   = 0xA5;
	IAPPRGS = 0xD5;
	while (!IAP_DONE);
	IAPUL = 0x00;

	WDTUL  = 0x5A;
	SWDTEN = 1;

	if (bgie) {
		GIE = 1;
	}
#if IT_VECTOR_ENABLE == 1
	GIEL = 1;
#endif
	return true;
}

bool flash_read_byte(uint page, uint offsetaddr, uchar *byte_h, uchar *byte_l)
{
	uchar bgie;
	hword_to_byte_t tvar;

	bgie = 0;
	if (GIE) {
		GIE  = 0;
		bgie = 1;
	}

	tvar.hWord = page + offsetaddr;
	FRAH  = tvar.chByte[1];
	FRAL  = tvar.chByte[0];
	__Asm TBR;
	*byte_h = ROMDH;
	*byte_l = ROMDL;

	if (bgie) {
		GIE = 1;
	}
#if IT_VECTOR_ENABLE == 1
	GIEL = 1;
#endif
	return true;
}

/**
  * @brief   flashжȡ(2ֽ)
  * @param   [in]page:   flashҳַ
  * @param   [in]addr:   ҳƫƵַ
  * @param   [out]phword:ָ
  * @retval  true:ɹ/false:ʧ
  * @author  linxy
  * @date    2016/11/29
  * @note    
  */
bool flash_read_hword(uint page, uint offsetaddr, uint *phword)
{
	uchar bgie;
	hword_to_byte_t tvar;

	bgie = 0;
	if (GIE) {
		GIE  = 0;
		bgie = 1;
	}

	tvar.hWord = page + offsetaddr;
	FRAH  = tvar.chByte[1];
	FRAL  = tvar.chByte[0];
	__Asm TBR;
	tvar.chByte[1] = ROMDH;
	tvar.chByte[0] = ROMDL;
	*phword = tvar.hWord;

	if (bgie) {
		GIE = 1;
	}
#if IT_VECTOR_ENABLE == 1
	GIEL = 1;
#endif
	return true;
}

/**
  * @brief   ָҳַд(2ֽ)
  * @param   [in]page: flashҳַ
  * @param   [in]addr: ݴ洢ַҳ׵ַƫ
  * @param   [in]hword:(2Byte)
  * @retval  true:ɹ/false:ʧ
  * @author  linxy
  * @date    2016/11/29
  * @note    лʱرտŹʱӺȫж
  */
bool flash_write_hword(uint page, uint offsetaddr, uint hword)
{
	uchar bgie;
	hword_to_byte_t tvar;

	/*!< Ƿ */
	if ((s_tFlashOptionState.A != FLASH_OPTION_ENABLE_A) ||
	    (s_tFlashOptionState.B != FLASH_OPTION_ENABLE_B)) {
		return false;
	}

	/*!< ҳַǷϷ*/
	if (false == flash_page_check(page)) {
		return false;
	}

	bgie = 0;
	if (GIE) {
		GIE  = 0;
		bgie = 1;
	}

	WDTUL  = 0x5A;
	SWDTEN = 0;

	tvar.hWord = page + offsetaddr;
	FRAH  = tvar.chByte[1];
	FRAHN = ~tvar.chByte[1];
	FRAL  = tvar.chByte[0];
	FRALN = ~tvar.chByte[0];

	tvar.hWord = hword;
	ROMDH  = tvar.chByte[1];
	ROMDL  = tvar.chByte[0];
	ROMDHN = ~tvar.chByte[1];
	ROMDLN = ~tvar.chByte[0];

	IAPCLR  = 1;
	IAPUL   = 0xA5;
	IAPPRGS = 0xD5;
	while (!IAP_DONE);
	IAPUL = 0x00;

	WDTUL  = 0x5A;
	SWDTEN = 1;

	if (bgie) {
		GIE = 1;
	}
#if IT_VECTOR_ENABLE == 1
	GIEL = 1;
#endif
	return true;
}

/**
  * @brief   flashָҳ
  * @param   [in]page:ҳַöٱ
  * @retval  true:ɹfalse:ʧ
  * @author  linxy
  * @date    2016/11/29
  * @note    лʱرտŹʱӺȫж
  */
bool flash_erase(uint page)
{
	uchar bgie;
	hword_to_byte_t tvar;

	/*!< Ƿ */
	if ((s_tFlashOptionState.A != FLASH_OPTION_ENABLE_A) ||
	    (s_tFlashOptionState.B != FLASH_OPTION_ENABLE_B)) {
		return false;
	}

	/*!< ҳַǷϷ*/
	if (false == flash_page_check(page)) {
		return false;
	}

	bgie = 0;
	if (GIE) {
		GIE  = 0;
		bgie = 1;
	}

	WDTUL  = 0x5A;
	SWDTEN = 0;

	tvar.hWord = page;
	FRAH  = tvar.chByte[1];
	FRAL  = 0x00;
	FRAHN = ~tvar.chByte[1];;
	FRALN = 0xFF;

	ROMDH  = 0x00;
	ROMDL  = 0x00;
	ROMDHN = 0xFF;
	ROMDLN = 0xFF;

	IAPCLR = 1;
	IAPUL = 0xA5;
	IAPERSS = 0xAE;
	while (!IAP_DONE);
	IAPUL = 0x00;

	WDTUL  = 0x5A;
	SWDTEN = 1;

	if (bgie) {
		GIE = 1;
	}
#if IT_VECTOR_ENABLE == 1
	GIEL = 1;
#endif
	return true;
}

/**
  * @brief   flashֹɶflashĲдҪô˺.
  * @param   none
  * @retval  none
  * @author  linxy
  * @date    2016/11/29
  * @note    
  */
void flash_option_disable(void)
{
	s_tFlashOptionState.A = FLASH_OPTION_DISABLE_A;
	s_tFlashOptionState.B = FLASH_OPTION_DISABLE_B;
}

/**
  * @brief   flashʹܣʹǰҪȵô˺
  * @param   none
  * @retval  none
  * @author  linxy
  * @date    2016/11/29
  * @note    
  */
void flash_option_enable(void)
{
	s_tFlashOptionState.A = FLASH_OPTION_ENABLE_A;
	s_tFlashOptionState.B = FLASH_OPTION_ENABLE_B;
}

/***************************************************************************************************
                                              
***************************************************************************************************/

/* end of file -----------------------------------------------------------------------------------*/
